<?php

/* -----------------------------------------------------------------
 * 	$Id: golem.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Golem {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Golem() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Golem.de XML';
        $this->v_module_homepage = 'www.golem.de';
        $this->v_module_format = 'xml';
        $this->v_module_export_filename = 'golem.xml';
        $this->v_filename = 'golem.php';
        $this->v_keyname = 'GOLEM';
        $this->v_linkname = 'golem';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = false;
        $this->v_field_shipping_costs_free = false;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');
        $p_products_array['products_price_taxfree'] = number_format((double) $p_products_array['products_price_taxfree'], 2, '.', '');
        $p_products_array['products_quantity'] = (double) $p_products_array['products_quantity'];

        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));

        if (strlen($p_products_array['products_description']) > 197) {
            $p_products_array['products_description'] = substr($p_products_array['products_description'], 0, 195) . '..';
        }

        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_categories_last'] = 'group';
        $t_csv_fields_array['products_id'] = 'pid';
        $t_csv_fields_array['products_name'] = 'name';
        $t_csv_fields_array['manufacturers_name'] = 'manufacturer';
        $t_csv_fields_array['products_description'] = 'description';
        $t_csv_fields_array['products_ean'] = 'ean';
        $t_csv_fields_array['products_currency'] = 'currency';
        $t_csv_fields_array['products_price'] = 'extax';
        $t_csv_fields_array['products_price_taxfree'] = 'inctax';
        $t_csv_fields_array['products_quantity'] = 'availability';
        $t_csv_fields_array['products_link'] = 'url';

        return($t_csv_fields_array);
    }

    function create_xml($p_filename = '', $p_output_array = array()) {
        // parameter check
        if (empty($p_filename) || !is_string($p_filename)) {
            return false;
        }

        // xml header and basic information
        $xml_data = '<?xml version="1.0" encoding="iso-8859-1"?>' . "\n" . '<doc>' . "\n";

        foreach ($p_output_array AS $t_key => $t_data_array) {
            if ($t_key > 0) {
                $xml_data .= '<product>' . "\n";
                $xml_data .= '<group>' . $t_data_array[$this->get_arraykey_id('group', $p_output_array[0])] . '</group>' . "\n";
                $xml_data .= '<pid>' . $t_data_array[$this->get_arraykey_id('pid', $p_output_array[0])] . '</pid>' . "\n";
                $xml_data .= '<name>' . $t_data_array[$this->get_arraykey_id('name', $p_output_array[0])] . '</name>' . "\n";
                $xml_data .= '<manufacturer>' . $t_data_array[$this->get_arraykey_id('manufacturer', $p_output_array[0])] . '</manufacturer>' . "\n";
                $xml_data .= '<description>' . $t_data_array[$this->get_arraykey_id('description', $p_output_array[0])] . '</description>' . "\n";
                $xml_data .= '<ean>' . $t_data_array[$this->get_arraykey_id('ean', $p_output_array[0])] . '</ean>' . "\n";
                $xml_data .= '<prices>' . "\n";
                $xml_data .= '<price>' . "\n";
                $xml_data .= '<currency>' . $t_data_array[$this->get_arraykey_id('currency', $p_output_array[0])] . '</currency>' . "\n";
                $xml_data .= '<extax>' . $t_data_array[$this->get_arraykey_id('extax', $p_output_array[0])] . '</extax>' . "\n";
                $xml_data .= '<inctax>' . $t_data_array[$this->get_arraykey_id('inctax', $p_output_array[0])] . '</inctax>' . "\n";
                $xml_data .= '</price>' . "\n";
                $xml_data .= '</prices>' . "\n";
                $xml_data .= '<availability>' . $t_data_array[$this->get_arraykey_id('availability', $p_output_array[0])] . '</availability>' . "\n";
                $xml_data .= '<url>' . $t_data_array[$this->get_arraykey_id('url', $p_output_array[0])] . '</url>' . "\n";
                $xml_data .= '</product>' . "\n";
            }
        }

        $xml_data .= '</doc>' . "\n";

        // save file with new name
        $t_fp = fopen(DIR_FS_CATALOG . 'export/' . $p_filename, "w");
        fputs($t_fp, $xml_data . "\n");
        fclose($t_fp);

        // all done
        return true;
    }

    function get_arraykey_id($p_key_name, $p_source_array) {
        $array_count = 0;
        foreach ($p_source_array as $t_key => $t_value) {
            if ($t_value == $p_key_name) {
                return $array_count;
            }
            $array_count++;
        }

        return '0';
    }

}

?>